/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.client.rmc.PIHSCRMCClient;
import com.ibm.hsc.client.rmc.PIHSCRMCClientFactory;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PIDlparResourceSync {
    private static final String MOF_NAME = "Name";
    private static final UnsignedInt32 MIN_MAX_CONSTANT = new UnsignedInt32(-1L);
    private static final String MOF_LPAR_SLOT_ID = "LPARSlotID";
    private static final String MOF_MEM_REGION = "memRegion";

    public static void syncPendingToCurrent(OmCecMgr omCecMgr, Vector vector, String string, String string2) throws PIHscServerException, CIMException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparResourceSync.syncPendingToCurrent");
        }
        Enumeration enumeration = vector.elements();
        Map map = omCecMgr.getCmdHelper().getDefinedSlotStates();
        while (enumeration.hasMoreElements()) {
            UnsignedInt16 unsignedInt16 = null;
            CIMInstance cIMInstance = null;
            CIMInstance cIMInstance2 = (CIMInstance)enumeration.nextElement();
            cIMInstance = cIMInstance2.filterProperties(null, true, true);
            String string3 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
            PIDlparResourceSync.debug("partitionName = " + string3);
            int n = Integer.parseInt(string3.substring(0, string3.indexOf("*")));
            unsignedInt16 = new UnsignedInt16(n);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath.setNameSpace("root/ibmhscS1_0");
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)map.get(unsignedInt16);
            PIDlparResourceSync.debug("lparState = " + unsignedInt8);
            if (unsignedInt8 == null || unsignedInt8.intValue() != 2) continue;
            CIMValue cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath, MOF_NAME);
            String string4 = (String)cIMValue.getValue();
            if (string2.equals("mem")) {
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("CurAllocMem").getValue().getValue();
                PIDlparResourceSync.debug("currMem = " + unsignedInt32.intValue());
                UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMInstance.getProperty("PendAllocMem").getValue().getValue();
                PIDlparResourceSync.debug("pendMem = " + unsignedInt322.intValue());
                if (unsignedInt32.intValue() != unsignedInt322.intValue()) {
                    PIDlparResourceSync.debug("Setting current memory " + unsignedInt32.intValue() + " for partitionName " + string3);
                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt32, MIN_MAX_CONSTANT);
                }
            }
            if (string2.equals("cpu")) {
                // empty if block
            }
            if (!string2.equals("io")) continue;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparResourceSync.syncPendingToCurrent");
        }
    }

    private static void debug(String string) {
        System.out.println("PIDlparResourceSync." + string);
    }

    public static void memoryRecoveryForDump(OmCecMgr omCecMgr, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws Exception, CIMException, HSCRMCException, PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparResourceSync.memoryRecoveryForDump");
        }
        PIDlparResourceSync.debug("Starting doMemRecovery() : " + cIMObjectPath);
        String string = PIDlparResourceSync.getHostName();
        PIDlparResourceSync.debug("getting host name : " + string);
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
        if (cIMInstance == null) {
            String[] stringArray = new String[]{cIMObjectPath.toString()};
            throw new PIHscServerException("1586", stringArray, null);
        }
        String string2 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
        int n = ((UnsignedInt16)cIMInstance.getProperty("LMBSize").getValue().getValue()).intValue();
        PIDlparResourceSync.debug("CEC name = " + string2);
        PIHSCRMCClientFactory pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string2);
        Vector vector = PIDlparResourceSync.getPartitions(cIMObjectPath, providerCIMOMHandle);
        PIDlparResourceSync.debug("LPAR Instances : \n" + vector.toString());
        int n2 = 5;
        short s = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        UnsignedInt16 unsignedInt16 = null;
        CIMInstance cIMInstance2 = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        if (vector != null && !vector.isEmpty()) {
            PIDlparResourceSync.debug("lparInstVec  size= " + vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                CIMInstance cIMInstance3 = (CIMInstance)enumeration.nextElement();
                cIMInstance2 = cIMInstance3.filterProperties(null, true, true);
                String string3 = (String)cIMInstance2.getProperty(MOF_NAME).getValue().getValue();
                PIDlparResourceSync.debug("partitionName = " + string3);
                int n7 = Integer.parseInt(string3.substring(0, string3.indexOf("*")));
                unsignedInt16 = new UnsignedInt16(n7);
                PIDlparResourceSync.debug("lparID = " + unsignedInt16);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscS1_0");
                UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
                CIMProperty cIMProperty = cIMInstance2.getProperty("PartitionState");
                if (cIMProperty != null && (object = cIMProperty.getValue()) != null) {
                    unsignedInt8 = (UnsignedInt8)object.getValue();
                }
                PIDlparResourceSync.debug("lparState = " + unsignedInt8.intValue());
                if (2 <= Trace.LEVEL) {
                    Trace.trace("appahscF", "lparID = " + unsignedInt16);
                    Trace.trace("appahscF", "lparState = " + unsignedInt8.intValue());
                }
                if (unsignedInt8 == null || unsignedInt8.intValue() != 2) continue;
                object = (String)cIMInstance2.getProperty(MOF_NAME).getValue().getValue();
                n3 = ((UnsignedInt32)cIMInstance2.getProperty("CurAllocMem").getValue().getValue()).intValue();
                PIDlparResourceSync.debug("currMem = " + n3);
                n4 = ((UnsignedInt32)cIMInstance2.getProperty("RuntimeMem").getValue().getValue()).intValue();
                PIDlparResourceSync.debug("runtimeMem = " + n4);
                if (2 <= Trace.LEVEL) {
                    Trace.trace("appahscF", "currMem = " + n3);
                    Trace.trace("appahscF", "runtimeMem = " + n4);
                }
                if (n3 <= n4) continue;
                n5 = n3 - n4;
                PIDlparResourceSync.debug("num to vary on : " + n5);
                PIDlparResourceSync.debug("lmb size : " + n);
                n5 /= n;
                short s2 = ((UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue()).shortValue();
                PIDlparResourceSync.debug("defState = " + s2);
                if (2 <= Trace.LEVEL) {
                    Trace.trace("appahscF", "defState = " + s2);
                }
                if (130 == s2 || 129 == s2) {
                    Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
                    vector2.addElement(new CIMProperty(MOF_LPAR_SLOT_ID, new CIMValue((Object)unsignedInt16)));
                    vector2.addElement(new CIMProperty(MOF_MEM_REGION, new CIMValue((Object)new UnsignedInt32((long)n5))));
                    PIDlparResourceSync.debug("Varying ON on OS400 partition with " + n5 + " lmbs");
                    try {
                        UnsignedInt16 unsignedInt162 = new UnsignedInt16(n2 * 60);
                        omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, unsignedInt162, n3 / n);
                        PIDlparResourceSync.debug("Vary Off over");
                    }
                    catch (PIHscServerException pIHscServerException) {
                        HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                        pIHscServerException.printStackTrace();
                    }
                    continue;
                }
                try {
                    PIDlparResourceSync.debug("Varying ON on RPA partition with " + n5 + " lmbs");
                    pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient((String)object);
                    n6 = pIHSCRMCClient.rmcDLPAROp(n5, n2, s, "mem", null, "a");
                    PIDlparResourceSync.debug("RMC Vary ON Over for lparID : " + unsignedInt16);
                }
                catch (HSCRMCException hSCRMCException) {
                    HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                    hSCRMCException.printStackTrace();
                }
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparResourceSync.memoryRecoveryForDump");
        }
    }

    private static String getHostName() throws Exception {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private static Vector getPartitions(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException, Exception {
        PIDlparResourceSync.debug("Entering getPartitions()");
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition");
        cIMObjectPath2.setNameSpace("root/ibmhscS1_0");
        PIDlparResourceSync.debug("tmpObjPath = " + cIMObjectPath2);
        Vector vector = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMObjectPath, null, "GroupComponent", "PartComponent", true, true, null);
        PIDlparResourceSync.debug("getPartitions() -> lparInstVec size = " + vector.size());
        PIDlparResourceSync.debug("getPartitions() -> " + vector.toString());
        if (2 <= Trace.LEVEL) {
            Trace.trace("appahscF", "getPartitions() -> " + vector.toString());
        }
        return vector;
    }
}

